
###############################################################################################################
## Table 1

library(VGAM)

load("~/data.Rda")
# note that D1 is the dependent variable
# I1: bilateral trade (ln)
# I2: Natural Resources
# I3: Preference Affinity
# I4: Polity
# I5: GDP per capita (ln)
# I6: Population (ln)
# I7: Government Effectiveness
# I8: Distance to Capital (ln)

# model 1 all none oecd members
data.a <- data[data$oecd == 0,]
attach(data.a)
tobit1 <- vglm(D1 ~ I1 + I2 + I3 + I4 + I5 + I6 + I7 + I8, tobit(Lower = 0, Upper = Inf), data = data.a)
summary(tobit1)
nrow(fitted(tobit1))

# model 2 all states that with lower GDPpc than China
data.b <- data[data$I5 <= data$chngdppc2015,]
attach(data.b)
tobit2 <- vglm(D1 ~ I1 + I2 + I3 + I4 + I5 + I6 + I7 + I8, tobit(Lower = 0, Upper = Inf), data = data.b)
summary(tobit2)
nrow(fitted(tobit2))


# model 3 all states that with 50% lowerst GDPpc 
data.c <- data[data$gdp2015 <= data$q50,]
attach(data.c)
tobit3 <- vglm(D1 ~ I1 + I2 + I3 + I4 + I5 + I6 + I7 + I8, tobit(Lower = 0, Upper=Inf), data = data.c)
summary(tobit3)
nrow(fitted(tobit3))

summary(margEff(tobit1))
# each additional increase leads to how much additional incrase of dependent varaible
























